// config: norepeat

#include "GetObjects.js"
#include "GetObject.js"
#include "GetPoint.js"

function GetDirection( factory )
{
	factory.clearInput( 1 );
	factory.clearInput( 2 );
	factory.clearInput( 3 );
	factory.clearInput( 4 );
	factory.update();

	var ui = moi.ui;

	ui.clearPickedPoints();
	
	ui.beginUIUpdate();
	ui.hideUI( 'ExtrusionPrompt' );
	ui.hideUI( 'ExtrusionOptions' );
	ui.showUI( 'FirstDirectionPrompt' );
	ui.endUIUpdate();
	
	var pointpicker = ui.createPointPicker();
	
	pointpicker.bindResultPt( factory.getInput(3) );
	
	if ( !GetPoint( pointpicker ) )
		return false;
		
	ui.beginUIUpdate();
	ui.hideUI( 'FirstDirectionPrompt' );
	ui.showUI( 'SecondDirectionPrompt' );
	ui.endUIUPdate();
	
	pointpicker.clearBindings();
	pointpicker.bindResultPt( factory.getInput(1) );
	pointpicker.bindResultPt( factory.getInput(4) );
	
	if ( !GetPoint( pointpicker ) )
		return false;
		
	ui.beginUIUpdate();
	ui.hideUI( 'SecondDirectionPrompt' );
	ui.showUI( 'ExtrusionPrompt' );
	ui.showUI( 'ExtrusionOptions' );
	ui.endUIUpdate();
	
	ui.removeLastPickedPoint();

	return true;
}

function DoExtrude()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowCurves();
	objectpicker.allowFaces();
	
	if ( !GetObjects( objectpicker ) )
		return;

	var objects = objectpicker.objects;
	objects.sortBySelectionOrder();

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectionPrompt' );
	moi.ui.hideUI( 'done' );
	moi.ui.showUI( 'ExtrusionPrompt' );
	moi.ui.showUI( 'ExtrusionOptions' );
	
	if ( objects.numFacesFromMultiFaceBReps > 0 )
		moi.ui.showUI( 'keepseparate' );
	
	moi.ui.endUIUpdate();

	var factory = moi.command.createFactory( 'extrude' );
	factory.setInput( 0, objects );

	factory.disableUpdate( true );
	moi.ui.bindUIToInput( 'capends', 'value', factory.getInput(5) );
	moi.ui.bindUIToInput( 'bothsides', 'value', factory.getInput(6) );
	moi.ui.bindUIToInput( 'keepseparate', 'value', factory.getInput(12) );
	factory.disableUpdate( false );

	var pointpicker = moi.ui.createPointPicker();
	pointpicker.bindResultPt( factory.getInput(1) );
	pointpicker.bindFunc( moi.ui.commandUI.OnPoint );

	var plane = factory.getExtrusionPlane();
	pointpicker.restrictToLinePtDir( plane.origin, plane.zaxis, true );
	
	moi.ui.commandUI.g_Factory = factory;

	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;

		if ( pointpicker.event == 'finished' )
		{
			break;
		}
		else if ( pointpicker.event == 'distanceinput' )
		{
			factory.setInput( 2, moi.ui.commandUI.distanceinput.value );
			factory.update();
			break;
		}
		else if ( pointpicker.event == 'setdirection' )
		{
			if ( !GetDirection( factory ) )
				return;
				
			pointpicker.clearBindings();
			pointpicker.bindResultPt( factory.getInput(1) );
			pointpicker.bindFunc( moi.ui.commandUI.OnPoint );
							
			plane = factory.getExtrusionPlane();
			pointpicker.restrictToLinePtDir( plane.origin, plane.zaxis, true );
		}
		else if ( pointpicker.event == 'setpath' )
		{
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'ExtrusionPrompt' );
			moi.ui.hideUI( 'ExtrusionOptions' );
			moi.ui.showUI( 'PathPrompt' );
			moi.ui.showUI( 'done' );
			moi.ui.endUIUpdate();
		
			factory.clearInput(1);
			factory.clearInput(2);
			factory.clearInput(3);
			factory.clearInput(4);
			factory.update();
			
			var pathpicker = moi.ui.createObjectPicker();
			pathpicker.allowCurves();
			
			if ( !GetObject( pathpicker ) )
				return;
				
			var path = pathpicker.objects.item(0);
				
			factory.setInput( 7, path );
			factory.update();
			break;
		}
		else if ( pointpicker.event == 'topoint' )
		{
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'btntable' );
			moi.ui.hideUI( 'disttable' );
			moi.ui.hideUI( 'bothsides' );
			moi.ui.showUI( 'unlockdircontainer' );
			moi.ui.endUIUpdate();
			
			factory.setInput( 9, true );
			factory.update();
		}
		else if ( pointpicker.event == 'unlockdir' )
		{
			pointpicker.clearRestriction();
		}
		else if ( pointpicker.event == 'tapered' )
		{
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'btntable' );
			moi.ui.hideUI( 'capends' );
			moi.ui.hideUI( 'bothsides' );
			moi.ui.showUI( 'draft_tr' );
			moi.ui.showUI( 'draftflip_tr' );
			moi.ui.endUIUpdate();
			
			factory.reset();
			factory.disableUpdate( true );
			moi.ui.bindUIToInput( 'draftangle', 'value', factory.getInput(10) );
			moi.ui.bindUIToInput( 'draftflip', 'value', factory.getInput(11) );
			factory.disableUpdate( false );
			factory.update();
		}
	}
	
	factory.commit();
}

DoExtrude();
